/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.watch.common.TlsClientAuthConfig;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TlsConfig
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(TlsConfig.class);
    private static final List<String> DEFAULT_TLS_PROTOCOLS = ImmutableList.of((Object)"TLSv1.2", (Object)"TLSv1.1");
    private String inlineTruststorePem;
    private Collection<? extends Certificate> inlineTrustCerts;
    private KeyStore trustStore;
    private TlsClientAuthConfig clientAuthConfig;
    private boolean verifyHostnames;
    private boolean trustAll;
    private SSLContext sslContext;

    public void init(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        this.inlineTruststorePem = vJsonNode.get("trusted_certs").asString();
        this.verifyHostnames = vJsonNode.get("verify_hostnames").withDefault(true).asBoolean();
        this.trustAll = vJsonNode.get("trust_all").withDefault(false).asBoolean();
        this.clientAuthConfig = (TlsClientAuthConfig)vJsonNode.get("client_auth").by(TlsClientAuthConfig::create);
        this.init(validationErrors);
        validationErrors.throwExceptionForPresentErrors();
    }

    public void init() throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.init(validationErrors);
        validationErrors.throwExceptionForPresentErrors();
    }

    private void init(ValidationErrors validationErrors) {
        try {
            this.inlineTrustCerts = TlsConfig.parseCertificates(this.inlineTruststorePem);
            this.trustStore = this.toTruststore("prefix", this.inlineTrustCerts);
        }
        catch (ConfigValidationException e) {
            validationErrors.add("trusted_certs", e);
        }
        try {
            this.sslContext = this.buildSSLContext(validationErrors);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(null, e);
        }
    }

    SSLContext buildSSLContext(ValidationErrors validationErrors) throws ConfigValidationException {
        try {
            if (this.trustAll) {
                return new OverlyTrustfulSSLContextBuilder().build();
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (this.trustStore != null) {
                try {
                    sslContextBuilder.loadTrustMaterial(this.trustStore, null);
                }
                catch (KeyStoreException | NoSuchAlgorithmException e) {
                    log.error("Error while building SSLContext for " + this, (Throwable)e);
                    throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
                }
            }
            if (this.clientAuthConfig != null) {
                try {
                    this.clientAuthConfig.loadKeyMaterial(sslContextBuilder);
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("client_auth", e);
                }
            }
            return sslContextBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Error while building SSLContext for " + this, (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
    }

    private HostnameVerifier getHostnameVerifier() {
        if (this.verifyHostnames) {
            return new DefaultHostnameVerifier();
        }
        return NoopHostnameVerifier.INSTANCE;
    }

    private String[] getSupportedProtocols() {
        return DEFAULT_TLS_PROTOCOLS.toArray(new String[DEFAULT_TLS_PROTOCOLS.size()]);
    }

    private String[] getSupportedCipherSuites() {
        return null;
    }

    static Collection<? extends Certificate> parseCertificates(String pem) throws ConfigValidationException {
        CertificateFactory fact;
        if (pem == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.US_ASCII));
        try {
            fact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            log.error("Could not initialize X.509", (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, "Could not initialize X.509").cause((Throwable)e));
        }
        try {
            return fact.generateCertificates(inputStream);
        }
        catch (CertificateException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)pem, (Object)"PEM File").cause((Throwable)e));
        }
    }

    private KeyStore toTruststore(String trustCertificatesAliasPrefix, Collection<? extends Certificate> certificates) throws ConfigValidationException {
        KeyStore keyStore;
        if (certificates == null) {
            return null;
        }
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
        }
        catch (Exception e) {
            log.error("Could not initialize JKS KeyStore", (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, "Could not initialize JKS KeyStore").cause((Throwable)e));
        }
        int i = 0;
        for (Certificate certificate : certificates) {
            try {
                keyStore.setCertificateEntry(trustCertificatesAliasPrefix + "_" + i, certificate);
            }
            catch (KeyStoreException e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)certificate, (Object)"PEM File").cause((Throwable)e));
            }
            ++i;
        }
        return keyStore;
    }

    public SSLConnectionSocketFactory toSSLConnectionSocketFactory() {
        return new SSLConnectionSocketFactory(this.sslContext, this.getSupportedProtocols(), this.getSupportedCipherSuites(), this.getHostnameVerifier());
    }

    public static TlsConfig create(DocNode jsonNode) throws ConfigValidationException {
        TlsConfig result = new TlsConfig();
        result.init(jsonNode);
        return result;
    }

    public static TlsConfig parseJson(String json) throws ConfigValidationException {
        return TlsConfig.create(DocNode.parse((Format)Format.JSON).from(json));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inlineTruststorePem != null) {
            builder.field("trusted_certs", this.inlineTruststorePem);
        }
        if (this.clientAuthConfig != null) {
            builder.field("client_auth");
            this.clientAuthConfig.toXContent(builder, params);
        }
        if (this.verifyHostnames) {
            builder.field("verify_hostnames", this.verifyHostnames);
        }
        if (this.trustAll) {
            builder.field("trust_all", this.trustAll);
        }
        builder.endObject();
        return builder;
    }

    public String getInlineTruststorePem() {
        return this.inlineTruststorePem;
    }

    public void setInlineTruststorePem(String inlineTruststorePem) {
        this.inlineTruststorePem = inlineTruststorePem;
    }

    public TlsClientAuthConfig getClientAuthConfig() {
        return this.clientAuthConfig;
    }

    public void setClientAuthConfig(TlsClientAuthConfig clientAuthConfig) {
        this.clientAuthConfig = clientAuthConfig;
    }

    public boolean isVerifyHostnames() {
        return this.verifyHostnames;
    }

    public void setVerifyHostnames(boolean verifyHostnames) {
        this.verifyHostnames = verifyHostnames;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    private static class OverlyTrustfulTrustManager
    implements X509TrustManager {
        private OverlyTrustfulTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class OverlyTrustfulSSLContextBuilder
    extends SSLContextBuilder {
        private OverlyTrustfulSSLContextBuilder() {
        }

        protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            sslContext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[keyManagers.size()]) : null, new TrustManager[]{new OverlyTrustfulTrustManager()}, secureRandom);
        }
    }
}

